﻿
Partial Class changepassword
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site info class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    Protected Sub btnChange_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnChange.Click
        'var to store any error messages
        Dim ErrorMsg As String
        'var to store new password 1 entered by the user
        Dim NewPW1 As String
        'var to store the email address of current user
        Dim EMail As String
        'clear the error message label
        lblError.Text = ""
        'get the email address of the current user
        EMail = TheCurrentUser.EMail
        'validate the 
        ErrorMsg = FormValid()
        'if there are no errors
        If ErrorMsg = "" Then
            'read in the new password 1
            NewPW1 = txtNewPW1.Text
            'change the password
            Call ChangePassword(EMail, NewPW1)
            'tell the user this has been done
            lblError.Text = "Your password has been changed"
        Else
            'display any errors
            lblError.Text = ErrorMsg
        End If
    End Sub

    Protected Sub btnDone_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDone.Click
        'go back to the main page
        Response.Redirect("default.aspx")
    End Sub

    Sub ChangePassword(ByVal EMail As String, ByVal NewPW As String)
        'this sub changes the password for the user specified by their email address
        'find that user in the database
        Dim AUser As New DatabaseTable("dvd.mdb", "select * from Users where EMail='" & EMail & "'", "#PW", "#PN")
        'if the user has been found
        If AUser.Count = 1 Then
            'change the password
            AUser.RecordNumber(0).Item("UserPassword") = NewPW
            'save the changes
            AUser.SaveChanges()
        End If
    End Sub

    Function FormValid() As String
        'this function validates the contents of all of the fields
        'var to store any error messages
        Dim ErrMsg As String = ""
        'used to validate the password entered by the user
        Dim TempUser As New SwapShopUser
        'if the two new passwords do not match
        If txtNewPW1.Text <> txtNewPW2.Text Then
            ErrMsg = ErrMsg & " the new passwords do not match "
        End If
        'try to log in using the old password entered
        TempUser = New SwapShopUser(TheCurrentUser.EMail, txtOldPW.Text)
        'if it cant authenticate
        If TempUser.Authenticated = False Then
            ErrMsg = ErrMsg & " the old password is not correct "
        End If
        'if the new password doesnt contain a number
        If ContainsNumber(txtNewPW1.Text) = False Then
            ErrMsg = ErrMsg & " your password must contain a number "
        End If
        'if the new password is less than 7 characters
        If Len(txtNewPW1.Text) < 7 Then
            ErrMsg = ErrMsg & " your password must be at least seven characters long "
        End If
        'return any error messages 
        Return ErrMsg
    End Function

    Function ContainsNumber(ByVal Password As String) As Boolean
        'checks to see if the password contains a number
        'var for the loop
        Dim Count As Integer
        'flag for found
        Dim Found As Boolean
        'while not found and numbers still to look for
        While Not Found And Count <= 9
            'if password contains the number of count
            If Password.Contains(Count) Then
                'flag found as true
                Found = True
            Else
                'otherwise try the next number
                Count += 1
            End If
            'keep looking
        End While
        'return the state of found
        Return Found
    End Function

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'this event runs when the page is loaded
        'check that the current user has logged in
        Call CheckLogin()
    End Sub

    Sub CheckLogin()
        'this sub tests that the user has logged in correctly
        'if not then they are redirected to the main page
        'get the details of the current user from the session object
        TheCurrentUser = Session("TheCurrentUser")
        'if the current user object is not set up correctly
        If TheCurrentUser Is Nothing Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
        'if the current user is not authenticated
        If TheCurrentUser.Authenticated = False Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
    End Sub
End Class
